/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include "Filter_IE.h"

/*IE Filter bevat 3 filters. Twee daarvan zoekt naar URLS en de ander zoekt naar Cookies, de filters staan beschreven in "4. Internet Explorer".
Filter 1: beschreven in "4.1 URL's", ASCII form
Filter 2: beschreven in "4.1 URL's", Unicode form
Filter 3: cookies, beschreven in "4.2 Cookies" */

/*--------------------------------------------------------Filter 1--------------------------------------------------------*/
DUMP_SESSION* InitiateIEFilter1(char* location, char* argument, int analyse_type) {
		return CreateMemoryDump(location, "IE_URL_ASCII_Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt alle URL's waar heen is gesurft in de private sessie van Internet explorer .*/
int ApplyIEFilter1(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	/*In signature staat de string 
	
		"Visited :" user@URL

	hier begint elk adres mee waar naar toe is gesurft met een private sessie.
	*/
	char signature[9]={0x56, 0x69, 0x73, 0x69, 0x74, 0x65, 0x64, 0x3A, 0x20};
	char* moveBuff=buff;  //Positie in het geheugen waar de filter op dit moment bezig is
	char* moveBuff2=buff; //Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behoud
	int writtenBytes;	  //Returnvalue van Writefile()
	int readSize=0;		  //Tijdelijke parameter waar de grote van de string op wordt geplaatst.

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
				if(	memcmp(moveBuff, signature,  9) == 0) { //We willen alleen adressen die beginnen met "Visited :"

					/*Zoek het einde van de gebruikersnaam (deze eindigt met een apenstaartje)*/
					moveBuff2 = moveBuff+9;
					while(*moveBuff2!='@' && moveBuff2!=buff+overflowSize && *moveBuff2!=0)
						moveBuff2++;

					if(*moveBuff2=='@' && moveBuff2!=buff+overflowSize) {
						moveBuff2++;

						/*Controleer of de protocolnaam ook echt een protocolnaam is*/
						while(moveBuff2!=buff+overflowSize && *moveBuff2!=0
						&& !(*moveBuff2==':')
						&& !(
						(*moveBuff2 < 'a' || *moveBuff2 > 'z') 
						&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
						&& *moveBuff2 != '-'
						&& *moveBuff2 != '.')
						)
							moveBuff2++;

						/*Indien het einde van de protocolnaam gevonden is en deze klopt, schrijf de URL en gebruikersnaam weg*/
						if(moveBuff2!=buff+overflowSize && *moveBuff2!=0 &&
							(*moveBuff2==':')) {
							if(dmp->flags&DS_WRITE_LOCATION_STRING) {
								printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
								sprintf(dmp->string_location, "Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
								WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
							}

							moveBuff += 9; //Sla de string "Visited:" over


					
							//Schrijf de gevonden URL weg
							printf("%s\n", moveBuff);
							WriteFile(dmp->dumpFile, moveBuff, strlen(moveBuff), (LPDWORD) &writtenBytes, NULL);
							WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

							//Verschuif de buffer om verder te zoeken
							moveBuff += strlen(moveBuff) -1;
						}
					}
				}
			}
		//}				
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}

	return 0;
}

void DestroyIEFilter1(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter 1-----------------------------------------------------*/

/*--------------------------------------------------------Filter 2--------------------------------------------------------*/
DUMP_SESSION* InitiateIEFilter2(char* location, char* argument, int analyse_type) {
		return CreateUNICODEMemoryDump(location, "IE_URL_UNICODE_Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt alle URL's waar heen is gesurft in de private sessie van Internet explorer (UNICODE).*/
int ApplyIEFilter2(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	/*In signature staat de string 
	
		"Visited :" user@URL

	hier begint elk adres mee waar naar toe is gesurft met een private sessie.
	*/
	char signature[18]={0x56, 0x00, 0x69, 0x00, 0x73, 0x00, 0x69, 0x00, 0x74, 0x00, 0x65, 0x00, 0x64, 0x00, 0x3A, 0x00, 0x20, 0x00};
	char* moveBuff=buff;  //Positie in het geheugen waar de filter op dit moment bezig is
	wchar_t* moveBuff2; //Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behoud
	int writtenBytes;	  //Returnvalue van Writefile()
	int readSize=0;		  //Tijdelijke parameter waar de grote van de string op wordt geplaatst.

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			if(	memcmp(moveBuff, signature,   18) == 0) { //We willen alleen adressen die beginnen met "Visited :"

				/*Zoek het einde van de gebruikersnaam (deze eindigt met een apenstaartje)*/
				moveBuff2 = (wchar_t*) (moveBuff+18);
				while(*moveBuff2!='@' && moveBuff2!=(wchar_t*) (buff+overflowSize) && moveBuff2!=(wchar_t*) (buff+overflowSize+1)  && *moveBuff2!=0)
					moveBuff2++;

				if(*moveBuff2=='@' && moveBuff2!=(wchar_t*) (buff+overflowSize) && moveBuff2!=(wchar_t*) (buff+overflowSize+1)) {
					moveBuff2++;

					/*Controleer of de protocolnaam ook echt een protocolnaam is*/
					while(moveBuff2!=(wchar_t*) (buff+overflowSize) && moveBuff2!=(wchar_t*) (buff+overflowSize+1) 
					&& *moveBuff2!=0
					&& !(*moveBuff2==':')
					&& !(
					(*moveBuff2 < 'a' || *moveBuff2 > 'z') 
					&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
					&& *moveBuff2 != '-'
					&& *moveBuff2 != '.')
					)
						moveBuff2++;

					/*Indien het einde van de protocolnaam gevonden is en deze klopt, schrijf de URL en gebruikersnaam weg*/
					if(moveBuff2!=(wchar_t*) (buff+overflowSize) && moveBuff2!=(wchar_t*) (buff+overflowSize+1) 
						&& *moveBuff2!=0 &&
						(*moveBuff2==':')) {

						if(dmp->flags&DS_WRITE_LOCATION_STRING) {
							printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
							wsprintfW((LPWSTR) dmp->string_location, L"Address: %p, \0", (memlong) memInfo->BaseAddress + (moveBuff - buff));
							WriteFile(dmp->dumpFile, dmp->string_location, wcslen((wchar_t*) dmp->string_location)*2, (LPDWORD) &writtenBytes, NULL);
						}

						moveBuff += 18; //Sla de string "Visited:" over


					
						//Schrijf de gevonden URL weg
						wprintf(L"%s\n", moveBuff);
						WriteFile(dmp->dumpFile, moveBuff, wcslen((wchar_t*) moveBuff)*2, (LPDWORD) &writtenBytes, NULL);
						WriteFile(dmp->dumpFile, L"\r\n", wcslen(L"\r\n")*2, (LPDWORD) &writtenBytes, NULL);

						//Verschuif de buffer om verder te zoeken
						moveBuff += (wcslen((wchar_t*) moveBuff)*2) -1;
					}
				}
			}
		}			
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}

	return 0;
}

void DestroyIEFilter2(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter 2-----------------------------------------------------*/

/*--------------------------------------------------------Filter 3--------------------------------------------------------*/
DUMP_SESSION* InitiateIEFilter3(char* location, char* argument, int analyse_type) {
	DUMP_SESSION* tmpDump;
	tmpDump = CreateMemoryDump(location, "IE Cookie Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);

	/*
	Indien er live door memory gezocht wordt kunnen de cookies gevonden worden
	Indien er een bestand doorzocht wordt, kunnen allen de domeinnamen en geldende URL terug gevonden worden waar de cookies geldig waren, de cookies op zichzelf kunnen niet terug gevonden worden
	*/
	if(analyse_type==ANALYSE_MEMORY) {
		tmpDump->freePointer = createList();
		addToList(tmpDump->freePointer, createList());
		addToList(tmpDump->freePointer, createList());
	} else {
		tmpDump->freePointer = 0;
	}

	return tmpDump;
}

/*Zoeken naar cookies in IE stap 1*/
int ApplyIEFilter3(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	char* moveBuff=buff;
	char* moveBuff2;
	char* moveBuff3;
	char* moveBuff4;
	int writtenBytes;
	int readSize=0;
	int i;
	int extraSize;

	char* copyBuff = 0;


	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		if(dmp->freePointer!=0) {
			/*Backup het doorzochte memory, later wordt dit gebruikt om cookienamen en cookies waardes te zoeken.*/
			copyBuff = (char*) malloc(sizeof(MEMORY_BASIC_INFORMATION) + overflowSize + default_empty_overflow_size);
			memcpy(copyBuff, memInfo, sizeof(MEMORY_BASIC_INFORMATION));
			memcpy(copyBuff + sizeof(MEMORY_BASIC_INFORMATION), buff, overflowSize);
			addToList(getFromList(dmp->freePointer, 0), (void*) copyBuff);
		}

		/*De overflow buffer mag gebruikt worden om URL's die beginnen in het gewone deel niet af te kappen
		In die geval zoeken we naar twee strings die hetzelfde zijn, achter elkaar komen, maar gespiegeld zijn.
		Om deze reden zoeken we tot de helft van de overflow door.*/
		extraSize = (overflowSize - memInfo->RegionSize);
		if(extraSize!=0)
			extraSize /= 2;

		for(; moveBuff<(buff + memInfo->RegionSize + extraSize); moveBuff++) {
			if(moveBuff>(buff + 1)
				&&strlen(moveBuff) > 3) {  //URL is altijd groter dan 3 bytes
				moveBuff2 = moveBuff;

				/*Controleer of het domein voldoet aan de eisen en bestaat uit:
				- Letters a - z
				- Cijfers 0-9
				- '-' of '.' */
				while(moveBuff2!=buff+overflowSize
				&& *moveBuff2!=0
				&& !(
					(*moveBuff2 < 'a' || *moveBuff2 > 'z') 
					&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
					&& *moveBuff2 != '-'
					&& *moveBuff2 != '.'
				))
					moveBuff2++;

				/*Dit is de grote van de gevonde Domein*/
				readSize = moveBuff2 - moveBuff;


				moveBuff3 = moveBuff2;
				moveBuff3 += readSize + 1;

				/*Zijn we niet over de buffer heen?*/
				if(moveBuff2!=buff+overflowSize
				&& *moveBuff2==0 
				&& *moveBuff3==0) {

					moveBuff3 = moveBuff2 + 1;
					moveBuff2--;

					/*Controleer of de string die na de domein komt inderdaad de domein maar dan in tegenovergestelde richting is*/
					for(i=0; i<readSize; i++) {
						if(*moveBuff3 != *moveBuff2)
							break;

						moveBuff3++;
						moveBuff2--;
					}

					moveBuff4 = moveBuff;
					moveBuff4-=2;

					/*Zoek de URL die voor de domein staat*/
					while(moveBuff4!=buff
						&& *moveBuff4!=0)
						moveBuff4--;

					/*Hebben we de buffer niet overschreven en begint de url met een slash zoals het hoort?*/
					if(i==readSize
					&& *moveBuff3 == *moveBuff2
					&& (*moveBuff4==0 && *(moveBuff4+1)=='/'
					|| *moveBuff4=='/'
					&& moveBuff4<buff + memInfo->RegionSize)
					) {

						/*we hebben een URL gevonden, 
						- schrijf hem weg naar het bestand indien het om een bestandsanalyse gaat
						- zet hem in een lijst voor nader onderzoek (het zoeken van de cookies die bij de domein/url horen) indien het om een memory onderzoek gaat*/
						moveBuff2 = moveBuff + readSize+1;

						if(*moveBuff4==0)
							*moveBuff4++;

						if(dmp->freePointer!=0) {
							addToList(getFromList(dmp->freePointer, 1), (void*) ((memlong) memInfo->BaseAddress + (moveBuff4 - buff)));
						} else {
							if(dmp->flags&DS_WRITE_LOCATION_STRING) {
								printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
								sprintf(dmp->string_location, "Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
								WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
							}


							//Schrijf de gevonden URL weg
							printf("%s%s\n", moveBuff2, moveBuff4);
							WriteFile(dmp->dumpFile, moveBuff2, readSize, (LPDWORD) &writtenBytes, NULL);
							WriteFile(dmp->dumpFile, moveBuff4, strlen(moveBuff4), (LPDWORD) &writtenBytes, NULL);
							WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
						}

						//Verschuif de buffer om verder te zoeken
						moveBuff += ((readSize+1)*2) -1;
					} else {
						if(strlen(moveBuff))
							moveBuff += strlen(moveBuff) -1;
					}

				} else {
					if(strlen(moveBuff))
						moveBuff += strlen(moveBuff) -1;
				}
			} else {
				if(strlen(moveBuff))
					moveBuff += strlen(moveBuff) -1;
			}
		}	
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}

	return 0;
}

void DestroyIEFilter3(DUMP_SESSION* filter) {
	int i;
	//Ga op zoek naar cookies in Internet Exploer (indien de input virtuele memory was)
	if(filter->freePointer!=0) {
		//Ga de gemaakte lijst langs waar Domein en locaties gevonden zijn waar cookies geldig zijn
		for(i=0; i<countList(getFromList(filter->freePointer, 1)); i++) {
			char* foundOffset;
			char* pLocatie;					//Gevonde locatie waar cookie geldig is
			char* pDomein;					//Gevonde domein waar cookie geldig is
			char* pHeaderCookie;			//Gevonde cookie header
			char* vHeaderCookie;			//Gevonde cookie header Virtuele geheugen adres
			char* pcookieNaam;				//Gevonden cookie naam
			char* pcookieWaarde;			//Gevonden cookie waarde
			int writtenBytes;				//Returnvalue van Writefile()
			MEMORY_BASIC_INFORMATION* retMemInfo;	//Informatie over virtuele adressering van geheugen

			//Zet het virtuele adres, met daarop gevonden domein en locatie, om in een geldig adres in dit proces
			pLocatie = (char*) ProcessVirtualPointerToVP(getFromList(filter->freePointer, 0), getFromList(getFromList(filter->freePointer, 1), i));

			//De string na de locatie is domeinnaam in omgekeerde richting, we moeten dus de string die erna komt hebben als domein
			pDomein = pLocatie;
			pDomein += strlen(pDomein) + 1;
			pDomein += strlen(pDomein) + 1;

			/*Schrijf het gevonden (virtuele) adres weg waar de het domein en locatie gevonden hebben*/
			if(filter->flags&DS_WRITE_LOCATION_STRING) {
				printf("Address: %p: ", getFromList(getFromList(filter->freePointer, 1), i));
				sprintf(filter->string_location, "Address: %p: \r\n", getFromList(getFromList(filter->freePointer, 1), i));
				WriteFile(filter->dumpFile, filter->string_location, strlen(filter->string_location), (LPDWORD) &writtenBytes, NULL);
			}


			//Schrijf domein en locatie weg
			printf("%s%s\n", pDomein, pLocatie);
			WriteFile(filter->dumpFile, pDomein, strlen(pDomein), (LPDWORD) &writtenBytes, NULL);
			WriteFile(filter->dumpFile, pLocatie, strlen(pLocatie), (LPDWORD) &writtenBytes, NULL);
			WriteFile(filter->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
			WriteFile(filter->dumpFile, "------------", strlen("------------"), (LPDWORD) &writtenBytes, NULL);

			/*Hieronder gaan we het hele virtuele geheugen doorzoeken, we proberen de offset van locatie/domein ergens in het geheugen terug te vinden*/
			retMemInfo = 0;
			foundOffset = 0;
			pcookieNaam = 0;
			pHeaderCookie = 0;
			do { 
				foundOffset = (char*) findPointerInMemory(getFromList(filter->freePointer, 0), //Lijst
					getFromList(getFromList(filter->freePointer, 1), i), //lijst met bijbehorende virtuele adresering
					&retMemInfo, //Output waar gegevens over de gevonden adresing opstaan
					retMemInfo, //Laatst doorzochte virtele adresering (alles wat hiervoorkomt kan dus worden overgeslagen)
					foundOffset, //Het virtuele adres dat als laatst gevonden is
					MODE_32_BIT //Flags: MODE_32_BIT indien er gezaocht moet worden naar 32 bit adresering, heeft alleen effect als de applicatie een 64-bit applicatie is.
				);

				/*Controleer of het gevonden adres onderdeel is van een header van een cookie.*/
			} while(foundOffset!=0 && !((foundOffset - (char*)retMemInfo) >= 24 && *(int*)(foundOffset-20)==0 && *(int*)(foundOffset-24)==0));


			//Header gevonden van cookies (alle cookies die bij de domein/locatie horen)
			if(foundOffset!=0) {
				/*Verkrijg het adres van de cookie header*/
				pHeaderCookie = (char*) ProcessVirtualPointerToVP(getFromList(filter->freePointer, 0), (void*) *(int*)(foundOffset-16)); //Header van eerste cookie
				vHeaderCookie =  (char*) *(int*)(foundOffset-16); //Virtuele pointer naar header cookie
				do { //Loop alle cookies langs die bij deze header horen
					if(pHeaderCookie) {
						//Haal de naam en waarde uit het geheugen
						pcookieNaam = (char*) ProcessVirtualPointerToVP(getFromList(filter->freePointer, 0), (void*) *(int*)(pHeaderCookie+24));
						pcookieWaarde = (char*) ProcessVirtualPointerToVP(getFromList(filter->freePointer, 0), (void*) *(int*)(pHeaderCookie+28));

						/*Schrijf naam en waarde weg naar console en bestand*/
						WriteFile(filter->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

						if(filter->flags&DS_WRITE_LOCATION_STRING) {
							printf("Address: %p: ", vHeaderCookie);
							sprintf(filter->string_location, "Address: %p: \r\n", vHeaderCookie);
							WriteFile(filter->dumpFile, filter->string_location, strlen(filter->string_location), (LPDWORD) &writtenBytes, NULL);
						}

						printf("%s=%s\n", pcookieNaam, pcookieWaarde);
						WriteFile(filter->dumpFile, "naam: ", strlen("naam: "), (LPDWORD) &writtenBytes, NULL);
						if(pcookieNaam==0)
							WriteFile(filter->dumpFile, "Onbekend", strlen("Onbekend"), (LPDWORD) &writtenBytes, NULL);
						else
							WriteFile(filter->dumpFile, pcookieNaam, strlen(pcookieNaam), (LPDWORD) &writtenBytes, NULL);
						WriteFile(filter->dumpFile, "\r\nwaarde: ", strlen("\r\nwaarde: "), (LPDWORD) &writtenBytes, NULL);
						if(pcookieWaarde==0)
							WriteFile(filter->dumpFile, "Onbekend", strlen("Onbekend"), (LPDWORD) &writtenBytes, NULL);
						else
							WriteFile(filter->dumpFile, pcookieWaarde, strlen(pcookieWaarde), (LPDWORD) &writtenBytes, NULL);
						WriteFile(filter->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

						/*Verkrijg het adres van de volgende cookie in de lijst*/
						vHeaderCookie =  (char*) *(int*)(pHeaderCookie+20);
						pHeaderCookie  = (char*) ProcessVirtualPointerToVP(getFromList(filter->freePointer, 0), (void*) *(int*)(pHeaderCookie+20));
					}

				} while(pHeaderCookie!=0);
				WriteFile(filter->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
				WriteFile(filter->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
			}
		}

		/*Geef al het geheugen vrij met daarop het proces geheugen*/
		for(i = 0; i<countList(getFromList(filter->freePointer, 0)); i++) {
			free(getFromList(getFromList(filter->freePointer, 0), i));
		}

		freeList(getFromList(filter->freePointer, 0));
		freeList(getFromList(filter->freePointer, 1));

		freeList(filter->freePointer);
	}

	Destroy_MemoryDump(filter);
}

/*Zet een Vituele pointer uit het proces dat wordt geanalyseerd om in een geldige pointer in dit proces*/
void* ProcessVirtualPointerToVP(void* list, void* PVP) {
	int i=0;
	MEMORY_BASIC_INFORMATION* memInfo;

	if(PVP==0)
		return 0;

	for(i = 0; i<countList(list); i++) {
		memInfo = (MEMORY_BASIC_INFORMATION*) getFromList(list, i);
		if(memInfo->BaseAddress<=PVP
		&& (char*)memInfo->BaseAddress + memInfo->RegionSize > PVP)
			return (char*)memInfo + sizeof(MEMORY_BASIC_INFORMATION) + ((char*) PVP - memInfo->BaseAddress);
	}
	return 0;
}

/*Zoek naar een verwijzing naar een pointer in het geheugen*/
void* findPointerInMemory(void* list, void* PVP, MEMORY_BASIC_INFORMATION** retMemInfo, MEMORY_BASIC_INFORMATION* memOffset, void* offset, int flags) {
	int i=0;
	int pointer = 0;
	MEMORY_BASIC_INFORMATION* memInfo;
	char* searchBase;

	if(flags&MODE_32_BIT)
		pointer = (int) PVP;

	for(i = 0; i<countList(list); i++) {
		memInfo = (MEMORY_BASIC_INFORMATION*) getFromList(list, i);
		if(memOffset==0 ||
		memOffset==memInfo) {
			memOffset = 0;
			*retMemInfo = memInfo;
			searchBase = ((char*) memInfo) + sizeof(MEMORY_BASIC_INFORMATION);

			if(offset) {
				searchBase = offset;
				searchBase++;
				offset = 0;
			}

			for(; searchBase<((char*) memInfo + sizeof(MEMORY_BASIC_INFORMATION) + memInfo->RegionSize); searchBase++) {
				if(flags&MODE_32_BIT) {
					if(*(int*)searchBase == (int) PVP) {
						return searchBase;
					}
				
				} else {
					if(*(void**)searchBase == PVP) {
						return searchBase;
					}
				}
			}
		}
	}
	return 0;
}

/*-----------------------------------------------------Einde Filter 3-----------------------------------------------------*/